import asyncio
import json

from py_pli.pylib import VUnits, Measurements, send_msg
from py_pli.pylib import EndPointType, URPCFunctions
from pylog.pylogger import PyLogger
from virtualunits.HAL import HAL

import time

async def scantable_movement(pattern_file = 'positions.json', time_to_wait=1):

    msg = {'result': f'Start heatmap_scantable_movement'}
    await send_msg(json.dumps(msg))
    with open(pattern_file, 'r') as f:
        position_list = json.load(f)
    await VUnits.instance.hal.focusMover.Home()
    await VUnits.instance.hal.usLumFocusMover.Home()
    for position in sorted(position_list.keys(), key=int):
        x, y = position_list[position]
        msg_text = f'Move to Position {x}, {y}'
        msg = {'result': f'{msg_text}'}
        await send_msg(json.dumps(msg))
        await VUnits.instance.hal.scan_table.Move(x, y)
        msg = {'result': f'wait {time_to_wait}s...'}
        await send_msg(json.dumps(msg))
        await asyncio.sleep(time_to_wait)
    msg = {'result': f'finished !'}
    await send_msg(json.dumps(msg))
